/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.fabric;

import io.github.mortuusars.exposure.fabric.ExposureFabric;
import io.github.mortuusars.exposure.fabric.api.event.FrameAddedCallback;
import io.github.mortuusars.exposure.fabric.api.event.ModifyEntityInFrameExtraDataCallback;
import io.github.mortuusars.exposure.fabric.api.event.ModifyFrameExtraDataCallback;
import io.github.mortuusars.exposure.util.ExtraData;
import io.github.mortuusars.exposure.world.camera.capture.CaptureProperties;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.entity.CameraHolder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1820;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_9129;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlatformHelperImpl {
    @Nullable
    public static MinecraftServer getServer() {
        return ExposureFabric.server;
    }

    public static boolean canShear(class_1799 stack) {
        return stack.method_7909() instanceof class_1820;
    }

    public static boolean canStrip(class_1799 stack) {
        return stack.method_7909() instanceof class_1743;
    }

    public static void openMenu(class_3222 serverPlayer, final class_3908 menuProvider, final Consumer<class_9129> extraDataWriter) {
        ExtendedScreenHandlerFactory<byte[]> extendedScreenHandlerFactory = new ExtendedScreenHandlerFactory<byte[]>(){

            public byte[] getScreenOpeningData(class_3222 player) {
                class_9129 buffer = new class_9129((ByteBuf)PacketByteBufs.create(), player.method_56673());
                extraDataWriter.accept(buffer);
                byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buffer);
                buffer.release();
                return bytes;
            }

            @Nullable
            public class_1703 createMenu(int i, @NotNull class_1661 inventory, @NotNull class_1657 player) {
                return menuProvider.createMenu(i, inventory, player);
            }

            @NotNull
            public class_2561 method_5476() {
                return menuProvider.method_5476();
            }
        };
        serverPlayer.method_17355((class_3908)extendedScreenHandlerFactory);
    }

    public static List<String> getDefaultSpoutDevelopmentColorSequence() {
        return List.of("{FluidName:\"create:potion\",Amount:27000,Tag:{Potion:\"minecraft:awkward\"}}", "{FluidName:\"create:potion\",Amount:27000,Tag:{Potion:\"minecraft:thick\"}}", "{FluidName:\"create:potion\",Amount:27000,Tag:{Potion:\"minecraft:mundane\"}}");
    }

    public static List<String> getDefaultSpoutDevelopmentBWSequence() {
        return List.of("{FluidName:\"minecraft:water\",Amount:27000}");
    }

    public static boolean isModLoaded(String modId) {
        return FabricLoader.getInstance().isModLoaded(modId);
    }

    public static boolean isInDevEnv() {
        return FabricLoader.getInstance().isDevelopmentEnvironment();
    }

    public static void postModifyEntityInFrameExtraDataEvent(CameraHolder cameraHolder, class_1799 camera, class_1309 entityInFrame, ExtraData data) {
        ((ModifyEntityInFrameExtraDataCallback)ModifyEntityInFrameExtraDataCallback.EVENT.invoker()).modifyEntityInFrameData(cameraHolder, camera, entityInFrame, data);
    }

    public static void postModifyFrameExtraDataEvent(CameraHolder cameraHolder, class_1799 camera, CaptureProperties captureProperties, List<class_2338> positionsInFrame, List<class_1309> entitiesInFrame, ExtraData data) {
        ((ModifyFrameExtraDataCallback)ModifyFrameExtraDataCallback.EVENT.invoker()).modifyFrameExtraData(cameraHolder, camera, captureProperties, positionsInFrame, entitiesInFrame, data);
    }

    public static void postFrameAddedEvent(CameraHolder cameraHolder, class_1799 camera, Frame frame, List<class_2338> positionsInFrame, List<class_1309> entitiesInFrame) {
        ((FrameAddedCallback)FrameAddedCallback.EVENT.invoker()).frameAdded(cameraHolder, camera, frame, positionsInFrame, entitiesInFrame);
    }
}

